import{proxyCustomElement,HTMLElement,h,Fragment}from"@stencil/core/internal/client";import{a as apiFetch}from"./fetch.js";import{o as onFirstVisible}from"./lazy.js";import{i as intervalString}from"./price.js";import{f as formatTaxDisplay}from"./tax.js";import{g as getFeaturedProductMediaAttributes}from"./media.js";import{d as defineCustomElement$t}from"./sc-alert2.js";import{d as defineCustomElement$s}from"./sc-block-ui2.js";import{d as defineCustomElement$r}from"./sc-button2.js";import{d as defineCustomElement$q}from"./sc-card2.js";import{d as defineCustomElement$p}from"./sc-cc-logo2.js";import{d as defineCustomElement$o}from"./sc-dashboard-module2.js";import{d as defineCustomElement$n}from"./sc-divider2.js";import{d as defineCustomElement$m}from"./sc-empty2.js";import{d as defineCustomElement$l}from"./sc-flex2.js";import{d as defineCustomElement$k}from"./sc-format-bytes2.js";import{d as defineCustomElement$j}from"./sc-format-date2.js";import{d as defineCustomElement$i}from"./sc-format-number2.js";import{d as defineCustomElement$h}from"./sc-icon2.js";import{d as defineCustomElement$g}from"./sc-line-item2.js";import{d as defineCustomElement$f}from"./sc-order-manual-instructions2.js";import{d as defineCustomElement$e}from"./sc-order-status-badge2.js";import{d as defineCustomElement$d}from"./sc-payment-method2.js";import{d as defineCustomElement$c}from"./sc-product-line-item2.js";import{d as defineCustomElement$b}from"./sc-purchase-downloads-list2.js";import{d as defineCustomElement$a}from"./sc-quantity-select2.js";import{d as defineCustomElement$9}from"./sc-skeleton2.js";import{d as defineCustomElement$8}from"./sc-spacing2.js";import{d as defineCustomElement$7}from"./sc-spinner2.js";import{d as defineCustomElement$6}from"./sc-stacked-list2.js";import{d as defineCustomElement$5}from"./sc-stacked-list-row2.js";import{d as defineCustomElement$4}from"./sc-tag2.js";import{d as defineCustomElement$3}from"./sc-text2.js";import{d as defineCustomElement$2}from"./sc-tooltip2.js";import{a as addQueryArgs}from"./add-query-args.js";const scOrderCss=":host{display:block}.order__row{padding:var(--sc-spacing-large);display:grid;gap:var(--sc-spacing-small)}",ScOrder$1=proxyCustomElement(class extends HTMLElement{constructor(){super(),this.__registerHost(),this.__attachShadow(),this.orderId=void 0,this.customerIds=void 0,this.heading=void 0,this.order=void 0,this.purchases=void 0,this.loading=void 0,this.busy=void 0,this.error=void 0}componentDidLoad(){onFirstVisible(this.el,(()=>{this.fetchOrder(),this.fetchDownloads()}))}async fetchOrder(){try{this.loading=!0,await this.getOrder()}catch(e){console.error(this.error),this.error=(null==e?void 0:e.message)||wp.i18n.__("Something went wrong","surecart")}finally{this.loading=!1}}async fetchDownloads(){try{this.busy=!0,this.purchases=await apiFetch({path:addQueryArgs("surecart/v1/purchases",{expand:["product","product.downloads","download.media"],order_ids:[this.orderId],customer_ids:this.customerIds,downloadable:!0})})}catch(e){console.error(this.error),this.error=(null==e?void 0:e.message)||wp.i18n.__("Something went wrong","surecart")}finally{this.busy=!1}}async getOrder(){this.order=await apiFetch({path:addQueryArgs(`surecart/v1/orders/${this.orderId}`,{expand:["checkout","checkout.line_items","line_item.price","line_item.fees","line_item.variant","variant.image","price.product","checkout.manual_payment_method","checkout.payment_method","checkout.selected_shipping_choice","shipping_choice.shipping_method","payment_method.card","payment_method.payment_instrument","payment_method.paypal_account","payment_method.bank_account","checkout.discount","discount.promotion","checkout.charge"]})})}renderLoading(){return h("sc-flex",{flexDirection:"column",style:{gap:"1em"}},h("sc-skeleton",{style:{width:"20%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"60%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"40%",display:"inline-block"}}))}renderEmpty(){return h("sc-empty",{icon:"shopping-bag"},wp.i18n.__("Order not found.","surecart"))}renderContent(){var e,t,s,o,n,r,i,l,c,a,d,m,u;if(this.loading)return this.renderLoading();if(!(null===(e=this.order)||void 0===e?void 0:e.id))return this.renderEmpty();const p=null===(t=this.order)||void 0===t?void 0:t.checkout,v=null===(s=null==p?void 0:p.selected_shipping_choice)||void 0===s?void 0:s.shipping_method,f=null==v?void 0:v.name;return h(Fragment,null,((null===(o=null==p?void 0:p.line_items)||void 0===o?void 0:o.data)||[]).map((e=>{var t,s,o,n,r,i,l,c;const{url:a,title:d,alt:m}=getFeaturedProductMediaAttributes(null===(t=null==e?void 0:e.price)||void 0===t?void 0:t.product,null==e?void 0:e.variant);return h("sc-product-line-item",{key:e.id,imageUrl:a,imageAlt:m,imageTitle:d,name:null===(o=null===(s=null==e?void 0:e.price)||void 0===s?void 0:s.product)||void 0===o?void 0:o.name,priceName:null===(n=null==e?void 0:e.price)||void 0===n?void 0:n.name,variantLabel:((null==e?void 0:e.variant_options)||[]).filter(Boolean).join(" / ")||null,editable:!1,removable:!1,quantity:e.quantity,amount:e.subtotal_amount,currency:null===(r=null==e?void 0:e.price)||void 0===r?void 0:r.currency,trialDurationDays:null===(i=null==e?void 0:e.price)||void 0===i?void 0:i.trial_duration_days,interval:intervalString(null==e?void 0:e.price),scratchAmount:null==e?void 0:e.scratch_amount,setupFeeTrialEnabled:null===(l=null==e?void 0:e.price)||void 0===l?void 0:l.setup_fee_trial_enabled,fees:null===(c=null==e?void 0:e.fees)||void 0===c?void 0:c.data})})),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),h("sc-line-item",null,h("span",{slot:"description"},wp.i18n.__("Subtotal","surecart")),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.subtotal_amount})),!!(null==p?void 0:p.proration_amount)&&h("sc-line-item",null,h("span",{slot:"description"},wp.i18n.__("Proration","surecart")),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.proration_amount})),!!(null==p?void 0:p.applied_balance_amount)&&h("sc-line-item",null,h("span",{slot:"description"},wp.i18n.__("Applied Balance","surecart")),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.applied_balance_amount})),!!(null==p?void 0:p.discounts)&&h("sc-line-item",null,h("span",{slot:"description"},wp.i18n.__("Discount","surecart")),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.discounts})),!!(null===(r=null===(n=null==p?void 0:p.discount)||void 0===n?void 0:n.promotion)||void 0===r?void 0:r.code)&&h("sc-line-item",null,h("span",{slot:"description"},wp.i18n.__("Discount","surecart"),h("br",null),h("sc-tag",{type:"success"},wp.i18n.__("Coupon:","surecart")," ",null===(l=null===(i=null==p?void 0:p.discount)||void 0===i?void 0:i.promotion)||void 0===l?void 0:l.code)),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.discount_amount})),!!(null==p?void 0:p.shipping_amount)&&h("sc-line-item",null,h("span",{slot:"description"},`${wp.i18n.__("Shipping","surecart")} ${f?`(${f})`:""}`),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.shipping_amount})),!!(null==p?void 0:p.tax_amount)&&h("sc-line-item",null,h("span",{slot:"description"},formatTaxDisplay(null==p?void 0:p.tax_label)," (",null==p?void 0:p.tax_percent,"%)"),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.tax_amount})),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},wp.i18n.__("Total","surecart")),h("span",{slot:"price"},h("sc-format-number",{type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.total_amount})),h("span",{slot:"currency"},null==p?void 0:p.currency)),(null==p?void 0:p.amount_due)!==(null==p?void 0:p.total_amount)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},wp.i18n.__("Amount Due","surecart")),h("span",{slot:"price"},h("sc-format-number",{type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.amount_due})),h("span",{slot:"currency"},null==p?void 0:p.currency)),!!(null==p?void 0:p.charge)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},wp.i18n.__("Amount Paid","surecart")),h("span",{slot:"price"},h("sc-format-number",{type:"currency",currency:null===(c=null==p?void 0:p.charge)||void 0===c?void 0:c.currency,value:(null===(a=null==p?void 0:p.charge)||void 0===a?void 0:a.amount)?(null===(d=null==p?void 0:p.charge)||void 0===d?void 0:d.amount)-(null===(m=null==p?void 0:p.charge)||void 0===m?void 0:m.refunded_amount):0})),h("span",{slot:"currency"},null===(u=null==p?void 0:p.charge)||void 0===u?void 0:u.currency)))}render(){var e,t,s,o,n,r,i;const l=null===(e=null==this?void 0:this.order)||void 0===e?void 0:e.checkout,c=null==l?void 0:l.manual_payment_method;return h("sc-spacing",{style:{"--spacing":"var(--sc-spacing-large)"}},h("sc-dashboard-module",{error:this.error},h("span",{slot:"heading"},this.loading?h("sc-skeleton",{style:{width:"120px"}}):`#${null===(t=null==this?void 0:this.order)||void 0===t?void 0:t.number}`),!this.loading&&!(null==l?void 0:l.live_mode)&&h("sc-tag",{type:"warning",slot:"end"},wp.i18n.__("Test Mode","surecart")),!!(null==c?void 0:c.name)&&!!(null==c?void 0:c.instructions)&&h("sc-order-manual-instructions",{manualPaymentTitle:null==c?void 0:c.name,manualPaymentInstructions:null==c?void 0:c.instructions}),h("sc-card",{"no-padding":!this.loading},this.loading?this.renderLoading():h(Fragment,null,h("sc-stacked-list",null,h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,wp.i18n.__("Order Status","surecart")),h("sc-order-status-badge",{status:null===(s=null==this?void 0:this.order)||void 0===s?void 0:s.status})),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,wp.i18n.__("Date","surecart")),h("sc-format-date",{type:"timestamp",date:null===(o=this.order)||void 0===o?void 0:o.created_at,month:"short",day:"numeric",year:"numeric"})),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,wp.i18n.__("Payment Method","surecart")),h("sc-payment-method",{paymentMethod:null==l?void 0:l.payment_method})),h("div",{class:"order__row"},this.renderContent()))))),(null===(n=this.order)||void 0===n?void 0:n.statement_url)&&h("sc-button",{type:"primary",href:null===(r=this.order)||void 0===r?void 0:r.statement_url,target:"_blank"},h("sc-icon",{name:"inbox",slot:"prefix"}),wp.i18n.__("Download Receipt/Invoice","surecart")),!!(null===(i=this.purchases)||void 0===i?void 0:i.length)&&h("sc-purchase-downloads-list",{heading:wp.i18n.__("Downloads","surecart"),purchases:this.purchases}))}get el(){return this}static get style(){return scOrderCss}},[1,"sc-order",{orderId:[1,"order-id"],customerIds:[16],heading:[1],order:[32],purchases:[32],loading:[32],busy:[32],error:[32]}]);function defineCustomElement$1(){"undefined"!=typeof customElements&&["sc-order","sc-alert","sc-block-ui","sc-button","sc-card","sc-cc-logo","sc-dashboard-module","sc-divider","sc-empty","sc-flex","sc-format-bytes","sc-format-date","sc-format-number","sc-icon","sc-line-item","sc-order-manual-instructions","sc-order-status-badge","sc-payment-method","sc-product-line-item","sc-purchase-downloads-list","sc-quantity-select","sc-skeleton","sc-spacing","sc-spinner","sc-stacked-list","sc-stacked-list-row","sc-tag","sc-text","sc-tooltip"].forEach((e=>{switch(e){case"sc-order":customElements.get(e)||customElements.define(e,ScOrder$1);break;case"sc-alert":customElements.get(e)||defineCustomElement$t();break;case"sc-block-ui":customElements.get(e)||defineCustomElement$s();break;case"sc-button":customElements.get(e)||defineCustomElement$r();break;case"sc-card":customElements.get(e)||defineCustomElement$q();break;case"sc-cc-logo":customElements.get(e)||defineCustomElement$p();break;case"sc-dashboard-module":customElements.get(e)||defineCustomElement$o();break;case"sc-divider":customElements.get(e)||defineCustomElement$n();break;case"sc-empty":customElements.get(e)||defineCustomElement$m();break;case"sc-flex":customElements.get(e)||defineCustomElement$l();break;case"sc-format-bytes":customElements.get(e)||defineCustomElement$k();break;case"sc-format-date":customElements.get(e)||defineCustomElement$j();break;case"sc-format-number":customElements.get(e)||defineCustomElement$i();break;case"sc-icon":customElements.get(e)||defineCustomElement$h();break;case"sc-line-item":customElements.get(e)||defineCustomElement$g();break;case"sc-order-manual-instructions":customElements.get(e)||defineCustomElement$f();break;case"sc-order-status-badge":customElements.get(e)||defineCustomElement$e();break;case"sc-payment-method":customElements.get(e)||defineCustomElement$d();break;case"sc-product-line-item":customElements.get(e)||defineCustomElement$c();break;case"sc-purchase-downloads-list":customElements.get(e)||defineCustomElement$b();break;case"sc-quantity-select":customElements.get(e)||defineCustomElement$a();break;case"sc-skeleton":customElements.get(e)||defineCustomElement$9();break;case"sc-spacing":customElements.get(e)||defineCustomElement$8();break;case"sc-spinner":customElements.get(e)||defineCustomElement$7();break;case"sc-stacked-list":customElements.get(e)||defineCustomElement$6();break;case"sc-stacked-list-row":customElements.get(e)||defineCustomElement$5();break;case"sc-tag":customElements.get(e)||defineCustomElement$4();break;case"sc-text":customElements.get(e)||defineCustomElement$3();break;case"sc-tooltip":customElements.get(e)||defineCustomElement$2()}}))}const ScOrder=ScOrder$1,defineCustomElement=defineCustomElement$1;export{ScOrder,defineCustomElement};