import{Fragment,h}from"@stencil/core";import{sprintf,__}from"@wordpress/i18n";import{addQueryArgs}from"@wordpress/url";import apiFetch from"../../../../functions/fetch";import{onFirstVisible}from"../../../../functions/lazy";import{productNameWithPrice}from"../../../../functions/price";export class ScSubscription{constructor(){this.subscriptionId=void 0,this.showCancel=void 0,this.heading=void 0,this.query=void 0,this.protocol=void 0,this.subscription=void 0,this.updatePaymentMethodUrl=void 0,this.loading=void 0,this.cancelModal=void 0,this.resubscribeModal=void 0,this.busy=void 0,this.error=void 0}componentWillLoad(){onFirstVisible(this.el,(()=>{this.subscription||this.getSubscription()}))}async cancelPendingUpdate(){var t;if(confirm(__("Are you sure you want to cancel the pending update to your plan?","surecart")))try{this.busy=!0,this.subscription=await apiFetch({path:addQueryArgs(`surecart/v1/subscriptions/${null===(t=this.subscription)||void 0===t?void 0:t.id}/`,{expand:["price","price.product","current_period","period.checkout","purchase","purchase.license","license.activations","discount","discount.coupon"]}),method:"PATCH",data:{purge_pending_update:!0}})}catch(t){(null==t?void 0:t.message)?this.error=t.message:this.error=__("Something went wrong","surecart"),console.error(this.error)}finally{this.busy=!1}}async renewSubscription(){var t;try{this.error="",this.busy=!0,this.subscription=await apiFetch({path:addQueryArgs(`surecart/v1/subscriptions/${null===(t=this.subscription)||void 0===t?void 0:t.id}/renew`,{expand:["price","price.product","current_period","period.checkout","purchase","purchase.license","license.activations","discount","discount.coupon"]}),method:"PATCH"})}catch(t){this.error=(null==t?void 0:t.message)||__("Something went wrong","surecart")}finally{this.busy=!1}}async getSubscription(){var t;try{this.loading=!0,this.subscription=await await apiFetch({path:addQueryArgs(`surecart/v1/subscriptions/${this.subscriptionId||(null===(t=this.subscription)||void 0===t?void 0:t.id)}`,{expand:["price","price.product","current_period"],...this.query||{}})})}catch(t){(null==t?void 0:t.message)?this.error=t.message:this.error=__("Something went wrong","surecart"),console.error(this.error)}finally{this.loading=!1}}renderName(t){var e;return"string"!=typeof(null===(e=null==t?void 0:t.price)||void 0===e?void 0:e.product)?productNameWithPrice(null==t?void 0:t.price):__("Subscription","surecart")}renderRenewalText(t){const e=h("sc-subscription-status-badge",{subscription:t});return(null==t?void 0:t.cancel_at_period_end)&&t.current_period_end_at?h("span",null,e," ",sprintf(__("Your plan will be canceled on","surecart"))," ",h("sc-format-date",{date:1e3*t.current_period_end_at,month:"long",day:"numeric",year:"numeric"})):"trialing"===t.status&&t.trial_end_at?h("span",null,e," ",sprintf(__("Your plan begins on","surecart"))," ",h("sc-format-date",{date:1e3*t.trial_end_at,month:"long",day:"numeric",year:"numeric"})):"active"===t.status&&t.current_period_end_at?h("span",null,e," ",sprintf(__("Your plan renews on","surecart"))," ",h("sc-format-date",{date:1e3*t.current_period_end_at,month:"long",day:"numeric",year:"numeric"})):e}renderEmpty(){return h("slot",{name:"empty"},__("This subscription does not exist.","surecart"))}renderLoading(){return h("sc-stacked-list-row",{style:{"--columns":"2"},"mobile-size":0},h("div",{style:{padding:"0.5em"}},h("sc-skeleton",{style:{width:"30%",marginBottom:"0.75em"}}),h("sc-skeleton",{style:{width:"20%",marginBottom:"0.75em"}}),h("sc-skeleton",{style:{width:"40%"}})))}renderContent(){return this.loading?this.renderLoading():this.subscription?h(Fragment,null,h("sc-subscription-next-payment",{subscription:this.subscription,updatePaymentMethodUrl:this.updatePaymentMethodUrl},h("sc-subscription-details",{subscription:this.subscription}))):this.renderEmpty()}render(){var t,e,i,s,r,o,n;const c=(null==this?void 0:this.subscription.payment_method)||(null==this?void 0:this.subscription.manual_payment);return h("sc-dashboard-module",{heading:this.heading||__("Current Plan","surecart"),class:"subscription",error:this.error},!!this.subscription&&h("sc-flex",{slot:"end",class:"subscription__action-buttons"},this.updatePaymentMethodUrl&&c&&h("sc-button",{type:"link",href:this.updatePaymentMethodUrl},h("sc-icon",{name:"credit-card",slot:"prefix"}),__("Update Payment Method","surecart")),!c&&h("sc-button",{type:"link",href:addQueryArgs(window.location.href,{action:"create",model:"payment_method",id:null==this?void 0:this.subscription.id,...!1===(null===(t=null==this?void 0:this.subscription)||void 0===t?void 0:t.live_mode)?{live_mode:!1}:{}})},h("sc-icon",{name:"credit-card",slot:"prefix"}),__("Add Payment Method","surecart")),!!Object.keys(null===(e=this.subscription)||void 0===e?void 0:e.pending_update).length&&h("sc-button",{type:"link",onClick:()=>this.cancelPendingUpdate()},h("sc-icon",{name:"x-octagon",slot:"prefix"}),__("Cancel Scheduled Update","surecart")),(null===(i=null==this?void 0:this.subscription)||void 0===i?void 0:i.cancel_at_period_end)?h("sc-button",{type:"link",onClick:()=>this.renewSubscription()},h("sc-icon",{name:"repeat",slot:"prefix"}),__("Restore Plan","surecart")):"canceled"!==(null===(s=this.subscription)||void 0===s?void 0:s.status)&&(null===(r=this.subscription)||void 0===r?void 0:r.current_period_end_at)&&this.showCancel&&h("sc-button",{type:"link",onClick:()=>this.cancelModal=!0},h("sc-icon",{name:"x",slot:"prefix"}),__("Cancel Plan","surecart")),"canceled"===(null===(o=this.subscription)||void 0===o?void 0:o.status)&&h("sc-button",{type:"link",...(null===(n=this.subscription)||void 0===n?void 0:n.payment_method)?{onClick:()=>this.resubscribeModal=!0}:{href:null==this?void 0:this.updatePaymentMethodUrl}},h("sc-icon",{name:"repeat",slot:"prefix"}),__("Resubscribe","surecart"))),h("sc-card",{style:{"--overflow":"hidden"},noPadding:!0},this.renderContent()),this.busy&&h("sc-block-ui",{spinner:!0}),h("sc-cancel-dialog",{subscription:this.subscription,protocol:this.protocol,open:this.cancelModal,onScRequestClose:()=>this.cancelModal=!1,onScRefresh:()=>this.getSubscription()}),h("sc-subscription-reactivate",{subscription:this.subscription,open:this.resubscribeModal,onScRequestClose:()=>this.resubscribeModal=!1,onScRefresh:()=>this.getSubscription()}))}static get is(){return"sc-subscription"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-subscription.scss"]}}static get styleUrls(){return{$:["sc-subscription.css"]}}static get properties(){return{subscriptionId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"The subscription ID"},attribute:"subscription-id",reflect:!1},showCancel:{type:"boolean",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Whether to show the cancel button"},attribute:"show-cancel",reflect:!1},heading:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Heading to display"},attribute:"heading",reflect:!1},query:{type:"unknown",mutable:!1,complexType:{original:"object",resolved:"object",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Query to pass to the API"}},protocol:{type:"unknown",mutable:!1,complexType:{original:"SubscriptionProtocol",resolved:"SubscriptionProtocol",references:{SubscriptionProtocol:{location:"import",path:"../../../../types"}}},required:!1,optional:!1,docs:{tags:[],text:"The subscription protocol"}},subscription:{type:"unknown",mutable:!0,complexType:{original:"Subscription",resolved:"Subscription",references:{Subscription:{location:"import",path:"../../../../types"}}},required:!1,optional:!1,docs:{tags:[],text:"The subscription"}},updatePaymentMethodUrl:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:"Update the payment method url"},attribute:"update-payment-method-url",reflect:!1}}}static get states(){return{loading:{},cancelModal:{},resubscribeModal:{},busy:{},error:{}}}static get elementRef(){return"el"}}